/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers;

import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PrivateCrafting;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.requestsystem.resolvers.core.AbstractCraftingRequestResolver;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrivateWorkerCraftingRequestResolver
extends AbstractCraftingRequestResolver {
    public PrivateWorkerCraftingRequestResolver(@NotNull ILocation location, @NotNull IToken<?> token, @NotNull JobEntry entry) {
        super(location, token, entry, false);
    }

    @Override
    @Nullable
    public List<IRequest<?>> getFollowupRequestForCompletion(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> completedRequest) {
        return null;
    }

    @Override
    public void onAssignedRequestBeingCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
    }

    @Override
    public void onAssignedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
    }

    @Override
    public void onRequestedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
    }

    @Override
    @NotNull
    public MutableComponent getRequesterDisplayName(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        if (!request.hasParent()) {
            return new TranslatableComponent("com.minecolonies.coremod.resolvers.crafter.private");
        }
        request = manager.getRequestForToken((IToken<?>)request.getParent());
        if (request == null) {
            return new TranslatableComponent("com.minecolonies.coremod.resolvers.crafter.private");
        }
        return request.getRequester().getRequesterDisplayName(manager, request).m_7220_((Component)new TextComponent(" (")).m_7220_((Component)new TranslatableComponent("com.minecolonies.coremod.resolvers.crafter.private")).m_7220_((Component)new TextComponent(")"));
    }

    @Override
    public int getPriority() {
        return 125;
    }

    @Override
    public boolean canBuildingCraftStack(@NotNull AbstractBuilding building, Predicate<ItemStack> stackPredicate) {
        for (ICraftingBuildingModule module : building.getModules(ICraftingBuildingModule.class)) {
            IRecipeStorage recipe = module.getFirstRecipe(stackPredicate);
            if (recipe == null || recipe.getIntermediate() != null && recipe.getIntermediate() != Blocks.f_50016_) continue;
            return true;
        }
        return false;
    }

    @Override
    protected IRequestable createNewRequestableForStack(ItemStack stack, int count, int minCount, IToken<?> recipeStorage) {
        return new PrivateCrafting(stack, count, minCount, recipeStorage);
    }
}

